package jp.united.adstirsdksampleapp;

import android.app.Activity;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;

public class AdMobVideoRewardAdActivity extends AdstirBaseActivity {

    private RewardedAd mRewardedAd;
    private Button load;
    private Button play;
    private TextView statusWaiting;
    private TextView statusLoading;
    private TextView statusLoaded;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_admob_videoreward_ad);
        ActionBar actionBar = getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.setDisplayShowHomeEnabled(true);


        statusWaiting = (TextView) findViewById(R.id.status_waiting);
        statusLoading = (TextView) findViewById(R.id.status_loading);
        statusLoaded = (TextView) findViewById(R.id.status_loaded);

        play = (Button) findViewById(R.id.button_play);
        play.setEnabled(false);
        play.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                play.setEnabled(false);
                setStatus(LoadStatus.WAITING);
                if (mRewardedAd != null) {
                    Activity activityContext = AdMobVideoRewardAdActivity.this;
                    mRewardedAd.show(activityContext, new OnUserEarnedRewardListener() {
                        @Override
                        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                            int rewardAmount = rewardItem.getAmount();
                            String rewardType = rewardItem.getType();
                        }
                    });
                }
            }
        });

        load = (Button) findViewById(R.id.button_load);
        load.setEnabled(true);
        load.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                load.setEnabled(false);
                setStatus(LoadStatus.LOADING);
                AdRequest adRequest = new AdRequest.Builder().build();
                RewardedAd.load(AdMobVideoRewardAdActivity.this, getString(R.string.videoreward_ad_unit_id),
                        adRequest, new RewardedAdLoadCallback(){
                            @Override
                            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                                load.setEnabled(true);
                                setStatus(LoadStatus.WAITING);
                                mRewardedAd = null;
                            }

                            @Override
                            public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                                play.setEnabled(true);
                                setStatus(LoadStatus.LOADED);
                                mRewardedAd = rewardedAd;
                                mRewardedAd.setFullScreenContentCallback(new FullScreenContentCallback() {
                                    @Override
                                    public void onAdShowedFullScreenContent() {
                                        load.setEnabled(true);
                                        setStatus(LoadStatus.WAITING);
                                        mRewardedAd = null;
                                    }

                                    @Override
                                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                                    }

                                    @Override
                                    public void onAdDismissedFullScreenContent() {
                                    }
                                });
                            }
                        });
            }
        });
    }

    private void setStatus(LoadStatus status) {

        setTextViewEnabled(statusWaiting, false);
        setTextViewEnabled(statusLoading, false);
        setTextViewEnabled(statusLoaded, false);

        switch (status) {
            case WAITING:
                setTextViewEnabled(statusWaiting, true);
                break;
            case LOADING:
                setTextViewEnabled(statusLoading, true);
                break;
            case LOADED:
                setTextViewEnabled(statusLoaded, true);
                break;
        }
    }

    private void setTextViewEnabled(TextView t, boolean enable) {
        if(enable) {
            t.setTextColor(getResources().getColor(R.color.colorActiveStatusText));
            t.setBackgroundResource(R.color.colorActiveStatusBackground);
        }else {
            t.setTextColor(getResources().getColor(R.color.colorInactiveStatusText));
            t.setBackgroundResource(R.color.colorInactiveStatusBackground);
        }
    }

}
