package jp.united.adstirsdksampleapp;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuItem;

import com.ad_stir.webview.MraidWebView;

public abstract class AdstirBaseActivity extends AppCompatActivity {

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {

        getMenuInflater().inflate(R.menu.menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.help) {
            Uri uri = Uri.parse(getString(R.string.contact_url));
            Intent intent = new Intent(Intent.ACTION_VIEW,uri);
            startActivity(intent);
        } else if (item.getItemId() == R.id.version) {
            // バージョン情報組み立て
            String sdk_version = "SDK Version " + MraidWebView.getSDKVersion() + "\n";
            sdk_version += "APP Version " + getVersionName(this);
            new AlertDialog.Builder(this)
                    .setTitle(R.string.version)
                    .setMessage(sdk_version)
                    .create().show();
        } else if (item.getItemId() == android.R.id.home) {
            finish();
        }
        return true;
    }

    public static String getVersionName(Context context) {
        PackageManager pm = context.getPackageManager();
        String versionName = "";
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            versionName = packageInfo.versionName;
        } catch (android.content.pm.PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionName;
    }
}
