package jp.united.adstirsdksampleapp;

import android.os.Bundle;
import androidx.appcompat.app.ActionBar;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.ad_stir.interstitial.AdstirVideoAds;
import com.ad_stir.videoreward.AdstirVideoReward;
import com.ad_stir.videoreward.AdstirVideoRewardListener;

public class IncentivizedVideoActivity extends AdstirBaseActivity {

    private boolean isRewarded = false;
    private AdstirVideoReward adstirVideoReward;
    private Button load;
    private Button play;
    private TextView statusWaiting;
    private TextView statusLoading;
    private TextView statusLoaded;
    private TextView reward;
    private int point;

    private AdstirVideoRewardListener listener = new AdstirVideoRewardListener() {

        public void onLoad(int spot_no) {
            play.setEnabled(true);
            setStatus(LoadStatus.LOADED);
        }
        public void onFailed(int spot_no) {
            load.setEnabled(true);
            setStatus(LoadStatus.WAITING);
        }
        public void onStart(int spot_no) {}
        public void onStartFailed(int spot_no) {
            load.setEnabled(true);
            setStatus(LoadStatus.WAITING);
        }
        public void onFinished(int spot_no) {}
        public void onReward(int spot_no) {
            isRewarded = true;
            reward.setText(String.valueOf(++point));
        }
        public void onRewardCanceled(int spot_no) {}
        public void onClose(int spot_no) {
            load.setEnabled(true);
            setStatus(LoadStatus.WAITING);
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_incentivized_video);
        ActionBar actionBar = getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.setDisplayShowHomeEnabled(true);

        statusWaiting = (TextView) findViewById(R.id.status_waiting);
        statusLoading = (TextView) findViewById(R.id.status_loading);
        statusLoaded = (TextView) findViewById(R.id.status_loaded);

        reward = (TextView) findViewById(R.id.reward);

        play = (Button) findViewById(R.id.button_play);
        play.setEnabled(false);
        play.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(adstirVideoReward.canShow()){
                    play.setEnabled(false);
                    setStatus(LoadStatus.WAITING);
                    adstirVideoReward.showRewardVideo();
                }
            }
        });

        load = (Button) findViewById(R.id.button_load);
        load.setEnabled(true);
        load.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                load.setEnabled(false);
                setStatus(LoadStatus.LOADING);
                adstirVideoReward.load();
            }
        });

        // 動画リワード、全画面インタースティシャルの初期化処理
        int[] spotIds = {
                getResources().getInteger(R.integer.incentive),
                getResources().getInteger(R.integer.interstitial)
        };
        AdstirVideoAds.init(this, getString(R.string.mediaId), spotIds);

        // スポットIDごとにインスタンスを生成します。ここではスポットID 1についてのみ生成します。
        adstirVideoReward = new AdstirVideoReward(this, getString(R.string.mediaId), getResources().getInteger(R.integer.incentive));
        adstirVideoReward.setAdstirVideoRewardListener(listener);
    }

    // 広告の一時停止等
    @Override
    protected void onResume() {
        if(adstirVideoReward != null) adstirVideoReward.resume();
        if(isRewarded) {
            isRewarded = false;
            Toast.makeText(this, R.string.reward_success, Toast.LENGTH_LONG).show();
        }
        super.onResume();
    }

    @Override
    protected void onPause() {
        if(adstirVideoReward != null) adstirVideoReward.pause();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        if(adstirVideoReward != null) adstirVideoReward.destroy();
        super.onDestroy();
    }

    private void setStatus(LoadStatus status) {

        setTextViewEnabled(statusWaiting, false);
        setTextViewEnabled(statusLoading, false);
        setTextViewEnabled(statusLoaded, false);

        switch (status) {
            case WAITING:
                setTextViewEnabled(statusWaiting, true);
                break;
            case LOADING:
                setTextViewEnabled(statusLoading, true);
                break;
            case LOADED:
                setTextViewEnabled(statusLoaded, true);
                break;
        }
    }

    private void setTextViewEnabled(TextView t, boolean enable) {
        if(enable) {
            t.setTextColor(getResources().getColor(R.color.colorActiveStatusText));
            t.setBackgroundResource(R.color.colorActiveStatusBackground);
        }else {
            t.setTextColor(getResources().getColor(R.color.colorInactiveStatusText));
            t.setBackgroundResource(R.color.colorInactiveStatusBackground);
        }
    }
}
