package jp.united.adstirsdksampleapp;

import android.os.Bundle;
import androidx.appcompat.app.ActionBar;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.ad_stir.interstitial.AdstirInterstitial;
import com.ad_stir.interstitial.AdstirInterstitialListener;
import com.ad_stir.interstitial.AdstirVideoAds;

public class InterstitialAdActivity extends AdstirBaseActivity {

    private AdstirInterstitial adstirInterstitial;
    private Button load;
    private Button play;
    private TextView statusWaiting;
    private TextView statusLoading;
    private TextView statusLoaded;

    private AdstirInterstitialListener listener = new AdstirInterstitialListener() {

        public void onLoad(int spot_no) {
            play.setEnabled(true);
            setStatus(LoadStatus.LOADED);
        }
        public void onFailed(int spot_no) {
            load.setEnabled(true);
            setStatus(LoadStatus.WAITING);
        }
        public void onStart(int spot_no) {}
        public void onStartFailed(int spot_no) {
            load.setEnabled(true);
            setStatus(LoadStatus.WAITING);
        }
        public void onFinished(int spot_no) {}
        public void onClose(int spot_no) {
            load.setEnabled(true);
            setStatus(LoadStatus.WAITING);
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_interstitial_ad);
        ActionBar actionBar = getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.setDisplayShowHomeEnabled(true);

        statusWaiting = (TextView) findViewById(R.id.status_waiting);
        statusLoading = (TextView) findViewById(R.id.status_loading);
        statusLoaded = (TextView) findViewById(R.id.status_loaded);

        play = (Button) findViewById(R.id.button_play);
        play.setEnabled(false);
        play.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(adstirInterstitial.canShow()){
                    play.setEnabled(false);
                    setStatus(LoadStatus.WAITING);
                    adstirInterstitial.show();
                }
            }
        });

        load = (Button) findViewById(R.id.button_load);
        load.setEnabled(true);
        load.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                load.setEnabled(false);
                setStatus(LoadStatus.LOADING);
                adstirInterstitial.load();
            }
        });

        // 動画リワード、全画面インタースティシャルの初期化処理
        int[] spotIds = {
                getResources().getInteger(R.integer.incentive),
                getResources().getInteger(R.integer.interstitial)
        };
        AdstirVideoAds.init(this, getString(R.string.mediaId), spotIds);

        // スポットIDごとにインスタンスを生成します。ここではスポットID 2についてのみ生成します。
        adstirInterstitial = new AdstirInterstitial(this, getString(R.string.mediaId), getResources().getInteger(R.integer.interstitial));
        adstirInterstitial.setAdstirInterstitialListener(listener);

    }

    // 広告の一時停止等
    @Override
    protected void onResume() {
        if(adstirInterstitial != null) adstirInterstitial.resume();
        super.onResume();
    }

    @Override
    protected void onPause() {
        if(adstirInterstitial != null) adstirInterstitial.pause();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        if(adstirInterstitial != null) adstirInterstitial.destroy();
        super.onDestroy();
    }

    private void setStatus(LoadStatus status) {

        setTextViewEnabled(statusWaiting, false);
        setTextViewEnabled(statusLoading, false);
        setTextViewEnabled(statusLoaded, false);

        switch (status) {
            case WAITING:
                setTextViewEnabled(statusWaiting, true);
                break;
            case LOADING:
                setTextViewEnabled(statusLoading, true);
                break;
            case LOADED:
                setTextViewEnabled(statusLoaded, true);
                break;
        }
    }

    private void setTextViewEnabled(TextView t, boolean enable) {
        if(enable) {
            t.setTextColor(getResources().getColor(R.color.colorActiveStatusText));
            t.setBackgroundResource(R.color.colorActiveStatusBackground);
        }else {
            t.setTextColor(getResources().getColor(R.color.colorInactiveStatusText));
            t.setBackgroundResource(R.color.colorInactiveStatusBackground);
        }
    }

}
