package jp.united.adstirsdksampleapp;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import com.ad_stir.common.Log;

public class MainActivity extends AdstirBaseActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Log.setLogLevel(3);


        final String[] items = {
                getResources().getString(R.string.banner_ad),
                getResources().getString(R.string.native_ad),
                getResources().getString(R.string.insentivized_video),
                getResources().getString(R.string.interstitial_ad),
                getResources().getString(R.string.admob_banner_ad),
                getResources().getString(R.string.admob_interstitial_ad),
                getResources().getString(R.string.admob_videoreward_ad),
                getResources().getString(R.string.admob_native_custom_ad),
        };


        ListView menu = (ListView) findViewById(R.id.main_menu);
        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(
                this, android.R.layout.simple_list_item_1, items);

        menu.setAdapter(arrayAdapter);
        menu.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Context context = getApplicationContext();
                switch (i) {
                    case 0:
                        startActivity(new Intent(context, BannerAdActivity.class));
                        break;
                    case 1:
                        startActivity(new Intent(context, NativeAdActivity.class));
                        break;
                    case 2:
                        startActivity(new Intent(context, IncentivizedVideoActivity.class));
                        break;
                    case 3:
                        startActivity(new Intent(context, InterstitialAdActivity.class));
                        break;
                    case 4:
                        startActivity(new Intent(context, AdMobBannerAdActivity.class));
                        break;
                    case 5:
                        startActivity(new Intent(context, AdMobInterstitialAdActivity.class));
                        break;
                    case 6:
                        startActivity(new Intent(context, AdMobVideoRewardAdActivity.class));
                        break;
                    case 7:
                        startActivity(new Intent(context, AdMobNativeCustomActivity.class));
                        break;
                    default:
                        break;
                }
            }
        });
    }

}
