package jp.united.adstirsdksampleapp;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.ad_stir.appopenad.AdstirAppOpenAd;
import com.ad_stir.appopenad.AdstirAppOpenAdListener;

public class MyApplication extends Application implements Application.ActivityLifecycleCallbacks {
    private AdstirAppOpenAd adstirAppOpenAd;
    private Activity activity;
    private final AdstirAppOpenAdListener listener = new AdstirAppOpenAdListener() {
        @Override
        public void onLoad(int spot_no) {
            // 広告の読み込みが完了した時の処理を記述できます。
        }
        @Override
        public void onFailed(int spot_no) {
            // 広告の読み込みが失敗した時の処理を記述できます。
        }
        @Override
        public void onStart(int spot_no) {
            // 広告が表示された時の処理を記述できます。
        }
        @Override
        public void onStartFailed(int spot_no) {
            // 広告の表示に失敗した時の処理を記述できます。
        }
        @Override
        public void onClose(int spot_no) {
            // 広告が閉じられた時の処理を記述できます。
        }
    };

    private final LifecycleEventObserver lifecycleEventObserver = (lifecycleOwner, event) -> {
        if (event == Lifecycle.Event.ON_START) {
            // アプリ復帰時に広告の表示を試みます
            // ここでは広告表示のないMainActivityを表示している時だけ広告の表示を試みます
            // こちらの実装例ではアプリの起動時には広告が表示されません。
            if (activity instanceof MainActivity) {
                showIfAvailable();
            }
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        // Activityのライフサイクルのコールバックを設定します
        registerActivityLifecycleCallbacks(this);
        // ライフサイクルイベントのオブザーバを設定します
        ProcessLifecycleOwner.get().getLifecycle().addObserver(lifecycleEventObserver);
    }

    // アプリ起動時広告の初期化を行います
    private void initAd(Activity activity) {
        if (adstirAppOpenAd == null) {
            adstirAppOpenAd = new AdstirAppOpenAd(activity, getString(R.string.mediaId), getResources().getInteger(R.integer.appopen_ad));
            adstirAppOpenAd.setAdstirAppOpenAdListener(listener);
        }
    }
    // アプリ起動時広告の読み込みが完了している場合は表示、そうでない場合は読み込みを行います
    private void showIfAvailable() {
        if (adstirAppOpenAd.canShow()) {
            adstirAppOpenAd.show();
        } else {
            adstirAppOpenAd.load();
        }
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {

    }

    @Override
    public void onActivityStarted(@NonNull Activity activity) {
        this.activity = activity;
        initAd(activity);
    }

    @Override
    public void onActivityResumed(@NonNull Activity activity) {

    }

    @Override
    public void onActivityPaused(@NonNull Activity activity) {

    }

    @Override
    public void onActivityStopped(@NonNull Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {

    }

}