package jp.united.adstirsdksampleapp;

import androidx.appcompat.app.ActionBar;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.ad_stir.nativead.AdstirNativeAd;
import com.ad_stir.nativead.AdstirNativeAdListener;
import com.ad_stir.nativead.AdstirNativeAdResponse;

public class NativeAdActivity extends AdstirBaseActivity {

    private AdstirNativeAd nativead;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_native_ad);
        ActionBar actionBar = getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.setDisplayShowHomeEnabled(true);

        nativead = new AdstirNativeAd(this, getString(R.string.mediaId), getResources().getInteger(R.integer.native_ad));
        nativead.setSponsoredText("SPONSORED");
        nativead.setListener(new AdstirNativeAdListener(){
            public void onReceive(final AdstirNativeAdResponse response){
                runOnUiThread(new Runnable(){
                    public void run(){

                        TextView titleView = (TextView) findViewById(R.id.native_ad_title);
                        titleView.setText(response.getTitle());

                        TextView descriptionView = (TextView) findViewById(R.id.native_ad_desc);
                        descriptionView.setText(response.getDescription());

                        ImageView iconView = (ImageView) findViewById(R.id.native_ad_icon);
                        response.bindIconToImageView(NativeAdActivity.this, iconView);

                        ImageView imageView = (ImageView) findViewById(R.id.native_ad_image);
                        response.bindImageToImageView(NativeAdActivity.this, imageView);

                        Button ctaView = (Button) findViewById(R.id.native_ad_cta);
                        ctaView.setText(response.getCta());
                        ctaView.setOnClickListener(new View.OnClickListener() {
                            public void onClick(View v) {
                                response.click();
                            }
                        });
                    }
                });
                response.impression();
            }
            public void onFailed(){
            }
        });
        nativead.getAd();
    }

}
