package jp.united.appopenadapplication;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.ad_stir.appopenad.AdstirAppOpenAd;
import com.ad_stir.appopenad.AdstirAppOpenAdListener;

public class MyApplication extends Application implements Application.ActivityLifecycleCallbacks {
    private AdstirAppOpenAd adstirAppOpenAd;
    public boolean isShowing = false;
    public int frequencyCount = 1;
    public static final int FREQUENCY_COUNT = 3;
    private AppOpenAdListener appOpenAdListener;
    private final AdstirAppOpenAdListener listener = new AdstirAppOpenAdListener() {
        @Override
        public void onLoad(int spot_no) {
            // 広告の読み込みが完了した時の処理を記述できます。
            if (appOpenAdListener != null) {
                appOpenAdListener.onLoad();
            }
        }
        @Override
        public void onFailed(int spot_no) {
            // 広告の読み込みが失敗した時の処理を記述できます。
        }
        @Override
        public void onStart(int spot_no) {
            // 広告が表示された時の処理を記述できます。
            isShowing = true;
        }
        @Override
        public void onStartFailed(int spot_no) {
            // 広告の表示に失敗した時の処理を記述できます。
            loadAd();
        }
        @Override
        public void onClose(int spot_no) {
            // 広告が閉じられた時の処理を記述できます。
            isShowing = false;
            if (appOpenAdListener != null) {
                appOpenAdListener.onClose();
            }
            loadAd();
        }
    };

    private final LifecycleEventObserver lifecycleEventObserver = (lifecycleOwner, event) -> {
        if (event == Lifecycle.Event.ON_START) {
            showIfAvailable();
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        // Activityのライフサイクルのコールバックを設定します
        registerActivityLifecycleCallbacks(this);
        // ライフサイクルイベントのオブザーバを設定します
        ProcessLifecycleOwner.get().getLifecycle().addObserver(lifecycleEventObserver);
    }

    // アプリ起動時広告の初期化を行います
    public void initAd(Activity activity) {
        if (adstirAppOpenAd == null) {
            adstirAppOpenAd = new AdstirAppOpenAd(activity, getString(R.string.mediaId), getResources().getInteger(R.integer.appopen_ad));
            adstirAppOpenAd.setAdstirAppOpenAdListener(listener);
        }
    }

    public void loadAd() {
        adstirAppOpenAd.load();
    }

    // アプリ起動時広告の読み込みが完了している場合は表示、そうでない場合は読み込みを行います
    public void showIfAvailable() {
        if (adstirAppOpenAd.canShow()) {
            // 広告の表示を行います
            // ここでは3回に一度の表示頻度で広告を表示するように設定してあります
            if (frequencyCount == 1) {
                frequencyCount = FREQUENCY_COUNT;
                adstirAppOpenAd.show();
            } else {
                frequencyCount--;
            }
        } else {
            adstirAppOpenAd.load();
        }
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {

    }

    @Override
    public void onActivityStarted(@NonNull Activity activity) {
        initAd(activity);
    }

    @Override
    public void onActivityResumed(@NonNull Activity activity) {

    }

    @Override
    public void onActivityPaused(@NonNull Activity activity) {

    }

    @Override
    public void onActivityStopped(@NonNull Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {

    }

    public void setAppOpenAdListener(AppOpenAdListener listener) {
        this.appOpenAdListener = listener;
    }

    public interface AppOpenAdListener {
        void onLoad();
        void onClose();
    }
}

