package jp.united.appopenadapplication;

import androidx.appcompat.app.AppCompatActivity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;

public class SplashActivity extends AppCompatActivity {
    private boolean isInited = false;

    private final MyApplication.AppOpenAdListener listener = new MyApplication.AppOpenAdListener() {
        @Override
        public void onLoad() {
            // 広告の準備が完了したら広告を表示します
            // アプリのメイン画面に遷移後は表示しないようにしてください
            MyApplication application = (MyApplication)getApplication();
            application.showIfAvailable();
        }
        @Override
        public void onClose() {
            // 広告の表示が完了したらメイン画面に遷移します
            MyApplication application = (MyApplication)getApplication();
            application.setAppOpenAdListener(null);
            startMainActivity();
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);

        MyApplication application = (MyApplication)getApplication();
        application.initAd(this);
        application.setAppOpenAdListener(listener);
        initMainContents();
    }

    public void startMainActivity() {
        MyApplication application = (MyApplication)getApplication();
        if (isInited && !application.isShowing) {
            application.initAd(this);
            application.setAppOpenAdListener(null);
            Intent intent = new Intent(this, MainActivity.class);
            this.startActivity(intent);
        }
    }

    // コンテンツの準備を行います。ここでは3秒かかるものとします。
    public void initMainContents() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            // アプリのメインコンテンツの準備が完了したらメイン画面に遷移します
            isInited = true;
            startMainActivity();
        }, 3000);
    }
}