//
//  AppOpenAdManager.h
//  AdstirAppOpenAdSampleApp
//

#import <Foundation/Foundation.h>
@import AdstirAds;

NS_ASSUME_NONNULL_BEGIN


@protocol AppOpenAdManagerDelegate <NSObject>
- (void)adDidLoad;
- (void)adDidClose;
@end

@interface AppOpenAdManager : NSObject <AdstirAppOpenAdDelegate>

@property (nonatomic, weak) id <AppOpenAdManagerDelegate> _Nullable delegate;
@property (nonatomic, strong) AdstirAppOpenAd * adstirAppOpenAd;
@property (nonatomic) int frequencyCount;

+ (nonnull AppOpenAdManager *)sharedInstance;
- (void)loadAd;
- (void)showIfAvailable;

@end

NS_ASSUME_NONNULL_END
