//
//  AppOpenAdManager.m
//  AdstirAppOpenAdSampleApp
//

#import "AppOpenAdManager.h"

static int const FREQUENCY_COUNT = 3;

@interface AppOpenAdManager ()

@end

@implementation AppOpenAdManager

+ (nonnull AppOpenAdManager *)sharedInstance {
    static AppOpenAdManager *instance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[AppOpenAdManager alloc] init];
        instance.frequencyCount = 1;
    });
    return instance;
}

- (void)didLoad {
    if (_delegate != nil) {
        [_delegate adDidLoad];
    }
}

- (void)didClose {
    if (_delegate != nil) {
        [_delegate adDidClose];
    }
}

- (void)loadAd {
    if (self.adstirAppOpenAd == nil) {
        self.adstirAppOpenAd = [[AdstirAppOpenAd alloc] initWithMedia:@"MEDIA-b8608ec6" spot:7];
        self.adstirAppOpenAd.delegate = self;
    }
    [self.adstirAppOpenAd load];
}

- (void)showIfAvailable {
    if ([self.adstirAppOpenAd canShow]) {
        // 広告の表示を行います
        // ここでは3回に一度の表示頻度で広告を表示するように設定してあります
        NSLog(@"%d", self.frequencyCount);
        if (self.frequencyCount == 1) {
            self.frequencyCount = FREQUENCY_COUNT;
            [self.adstirAppOpenAd show];
        } else {
            self.frequencyCount--;
        }
    } else {
        [self loadAd];
    }
}

#pragma mark - AppOpenAdManagerDelegate

- (void)adstirAppOpenAdDidLoad:(AdstirAppOpenAd *)appOpenAd
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
    [self didLoad];
}

- (void)adstirAppOpenAd:(AdstirAppOpenAd *)appOpenAd didFailToLoadWithError:(NSError *)error
{
    NSLog(@"%s %@", __PRETTY_FUNCTION__, error.localizedDescription);
}

- (void)adstirAppOpenAdDidShow:(AdstirAppOpenAd * __asadnonnull)appOpenAd
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
}

- (void)adstirAppOpenAd:(AdstirAppOpenAd * __asadnonnull)appOpenAd didFailToShowWithError:(NSError * __asadnonnull)error
{
    NSLog(@"%s %@", __PRETTY_FUNCTION__, error.localizedDescription);
    [self didClose];
    [self loadAd];
}

- (void)adstirAppOpenAdDidClose:(AdstirAppOpenAd * __asadnonnull)appOpenAd
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
    [self didClose];
    [self loadAd];
}

@end
