//
//  MainViewController.m
//  AdstirAppOpenAdSampleApp
//

#import "MainViewController.h"
#import "AppOpenAdManager.h"
@import AppTrackingTransparency;

@interface MainViewController ()
@property (weak, nonatomic) IBOutlet UILabel *frequencyLabel;

@end

@implementation MainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    if (@available(iOS 14.5, *)) {
        [self initAtt];
    }
    [self updateFrequencyLabel];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(applicationDidBecomeActive)
                                                 name:UIApplicationDidBecomeActiveNotification
                                               object:nil];
}

- (void)applicationDidBecomeActive {
    [self updateFrequencyLabel];
}

// コンテンツの準備を行います。ここでは3秒かかるものとします。
- (void)initContents {
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 3.0 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
        if (self.delegate != nil) {
            NSLog(@"%s", __PRETTY_FUNCTION__);
            self.isInited = YES;
            [self.delegate didInit];
        }
    });
}

- (void)updateFrequencyLabel {
    self.frequencyLabel.text = [[NSString alloc] initWithFormat:@"アプリに%d回復帰したら広告表示", AppOpenAdManager.sharedInstance.frequencyCount];
}

- (void) initAtt API_AVAILABLE(ios(14.5)) {
    UIApplication *applicaiton = [UIApplication sharedApplication];
    if (applicaiton.applicationState == UIApplicationStateActive) {
        if (ATTrackingManager.trackingAuthorizationStatus != ATTrackingManagerAuthorizationStatusDenied) {
            [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
            }];
        }
    }
}

@end
