//
//  SplashViewController.m
//  AdstirAppOpenAdSampleApp
//

#import "SplashViewController.h"
#import "MainViewController.h"

@interface SplashViewController ()
@property (strong, nonatomic) MainViewController *mainViewController;
@end

@implementation SplashViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    AppOpenAdManager.sharedInstance.delegate = self;
    self.mainViewController = [[MainViewController alloc] initWithNibName:@"MainViewController" bundle:nil];
    self.mainViewController.delegate = self;
    self.mainViewController.modalPresentationStyle = UIModalPresentationOverFullScreen;
    [self.mainViewController initContents];
}

- (void)startMainViewController {
    // 広告表示中でなければメイン画面に遷移します
    if (self.mainViewController.isInited && ![AppOpenAdManager.sharedInstance.adstirAppOpenAd isShowing]) {
        self.mainViewController.delegate = nil;
        AppOpenAdManager.sharedInstance.delegate = nil;
        [self presentViewController:self.mainViewController animated:YES completion:nil];
    }
}

#pragma mark - MainViewControllerDelegate
// アプリのメインコンテンツの準備が完了したらメイン画面に遷移します
- (void)didInit {
  [self startMainViewController];
}

#pragma mark - AppOpenAdManagerDelegate
// 広告の準備が完了したら広告を表示します
// アプリのメイン画面に遷移後は表示しないようにしてください
- (void)adDidLoad {
    [AppOpenAdManager.sharedInstance showIfAvailable];
}

// 広告の表示が完了したらメイン画面に遷移します
- (void)adDidClose {
  [self startMainViewController];
}

@end
