#import "AdMobBannerAdViewController.h"
@import GoogleMobileAds;

@interface AdMobBannerAdViewController () <GADBannerViewDelegate>

@property (nonatomic, strong) GADBannerView *bannerView;

@end

@implementation AdMobBannerAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // ここでは、320x50サイズのバナー広告を表示します。
    // サイズについての詳細は、営業担当者からお知らせ致します。
    // 広告表示位置: センタリング、広告サイズ: 320,50 の場合
    CGFloat originX = (self.view.frame.size.width - GADAdSizeBanner.size.width) / 2;
    CGFloat originY = (self.view.frame.size.height - GADAdSizeBanner.size.height) /2;
    
    GADBannerView *bannerView = [[GADBannerView alloc] initWithAdSize:GADAdSizeBanner origin:CGPointMake(originX, originY)];
    
    // 実際に配信に使用するAd Unit IDは、営業担当者から別途お知らせ致します。
    // こちらはテスト用のIDになります。
    bannerView.adUnitID = @"ca-app-pub-5957222543250452/1822743591";
    bannerView.rootViewController = self;
    // デリゲートは必要に応じて実装してください
    // See also: https://developers.google.com/admob/ios/banner#ad_events
    bannerView.delegate = self;
    
    [bannerView loadRequest:[GADRequest request]];
    [self.view addSubview:bannerView];
    
    self.bannerView = bannerView;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc {
    self.bannerView.delegate = nil;
    self.bannerView = nil;
}

#pragma mark -
#pragma mark GADBannerViewDelegate

- (void)bannerViewDidReceiveAd:(GADBannerView *)bannerView {
    // 広告取得完了時の動作を実装
}

- (void)bannerView:(GADBannerView *)bannerView didFailToReceiveAdWithError:(NSError *)error {
    // 広告取得失敗時の動作を実装
}

@end
