#import "AdMobIncentivizedVideoAdViewController.h"
@import GoogleMobileAds;

@interface AdMobIncentivizedVideoAdViewController () <GADFullScreenContentDelegate>

@property(nonatomic, strong) GADRewardedAd *rewardedAd;

@property (weak, nonatomic) IBOutlet UILabel *statusLabel;

@property (weak, nonatomic) IBOutlet UIButton *showVideoButton;

@property (weak, nonatomic) IBOutlet UILabel *waitingLabel;
@property (weak, nonatomic) IBOutlet UILabel *loadingLabel;
@property (weak, nonatomic) IBOutlet UILabel *loadedLabel;
@property (weak, nonatomic) IBOutlet UILabel *rewardCountLabel;
@property (nonatomic, strong)UIColor *redColor;
@property (nonatomic, strong)UIColor *grayColor;

@end


@implementation AdMobIncentivizedVideoAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // UI設定 ここから
    self.redColor = [UIColor colorWithRed:227/255.0 green:11/255.0 blue:32/255.0 alpha:1.0];
    self.grayColor = [UIColor colorWithRed:114/255.0 green:114/255.0 blue:114/255.0 alpha:1.0];
    
    self.showVideoButton.layer.cornerRadius = 25;
    [self.showVideoButton setTitleColor:[UIColor whiteColor] forState:normal];
    [self.showVideoButton setBackgroundColor:self.grayColor];
    [self.showVideoButton setAlpha:0.5];
    
    [self.waitingLabel setAlpha:0.5];
    [self.loadingLabel setAlpha:1];
    [self.loadedLabel setAlpha:0.5];
    
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    NSDictionary *dictionary = [NSDictionary dictionaryWithObjectsAndKeys:[NSNumber numberWithInteger:0], @"admobpoints", nil];
    [userDefaults registerDefaults:dictionary];
    
    NSNumber *rewardCount = [userDefaults objectForKey:@"admobpoints"];
    self.rewardCountLabel.text = [rewardCount stringValue];
    // ここまで
    
    // 動画リワードのインスタンス生成と読み込み
    [self loadRewardedAd];
}

- (void)loadRewardedAd {
    [self.waitingLabel setAlpha:0.5];
    [self.loadingLabel setAlpha:1];
    [self.loadedLabel setAlpha:0.5];
    
    GADRequest *request = [GADRequest request];
    [GADRewardedAd loadWithAdUnitID:@"ca-app-pub-5957222543250452/7075070275"
                            request:request
                  completionHandler:^(GADRewardedAd *ad, NSError *error) {
        if (error) {
            // 広告読み込み失敗
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                [self.waitingLabel setAlpha:0.5];
                [self.loadingLabel setAlpha:1];
                [self.loadedLabel setAlpha:0.5];
                [self loadRewardedAd];
            });
            return;
        }
        // 広告読み込み成功
        self.rewardedAd = ad;
        NSLog(@"Rewarded ad loaded.");
        self.rewardedAd.fullScreenContentDelegate = self;
        
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:0.5];
        [self.loadedLabel setAlpha:1];
        
        [self.showVideoButton setBackgroundColor:self.redColor];
        [self.showVideoButton setAlpha:1];
        self.showVideoButton.enabled = YES;
    }];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/** リワード広告を表示するボタンのターゲットメソッド */
- (IBAction)showVideoButtonDidTouchUpInside:(id)sender
{
    [self.showVideoButton setBackgroundColor:self.grayColor];
    [self.showVideoButton setAlpha:0.5];
    self.showVideoButton.enabled = NO;
    
    if (self.rewardedAd) {
      [self.rewardedAd presentFromRootViewController:self
                            userDidEarnRewardHandler:^ {
        GADAdReward *reward = self.rewardedAd.adReward;
          NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
          NSNumber *rewardCount = [userDefaults objectForKey:@"admobpoints"];
          rewardCount = [NSNumber numberWithInt:[rewardCount intValue] + [reward.amount intValue]];
          [userDefaults setObject:rewardCount forKey:@"admobpoints"];
          self.rewardCountLabel.text = [rewardCount stringValue];
      }];
    } else {
      NSLog(@"Ad wasn't ready");
    }
}


- (void)dealloc
{

}


#pragma mark -
#pragma mark GADFullScreenContentDelegate

/// Tells the delegate that the ad failed to present full screen content.
- (void)ad:(nonnull id<GADFullScreenPresentingAd>)ad
    didFailToPresentFullScreenContentWithError:(nonnull NSError *)error {
    NSLog(@"Ad failed to present full screen content with error %@.", [error localizedDescription]);
}

/// Tells the delegate that the ad will present full screen content.
- (void)adWillPresentFullScreenContent:(nonnull id<GADFullScreenPresentingAd>)ad {
    NSLog(@"Ad will present full screen content.");
}

/// Tells the delegate that the ad dismissed full screen content.
- (void)adDidDismissFullScreenContent:(nonnull id<GADFullScreenPresentingAd>)ad {
    NSLog(@"Ad did dismiss full screen content.");
    [self.waitingLabel setAlpha:1];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:0.5];

    // 15秒待ってから再読み込みします
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:1];
        [self.loadedLabel setAlpha:0.5];

        [self loadRewardedAd];
    });
}

@end
