#import "AdMobInterstitialAdViewController.h"
@import GoogleMobileAds;

#define ADMOB_INTERSTITIAL_ID @"ca-app-pub-5957222543250452/9050496922"

@interface AdMobInterstitialAdViewController () <GADFullScreenContentDelegate>
@property(nonatomic, strong) GADInterstitialAd *interstitial;

@property (weak, nonatomic) IBOutlet UIButton *showInterstitialButton;
@property (weak, nonatomic) IBOutlet UILabel *waitingLabel;
@property (weak, nonatomic) IBOutlet UILabel *loadingLabel;
@property (weak, nonatomic) IBOutlet UILabel *loadedLabel;
@property (nonatomic, strong)UIColor *redColor;
@property (nonatomic, strong)UIColor *grayColor;
@end

@implementation AdMobInterstitialAdViewController

- (void)viewDidLoad
{
    // UI設定 ここから
    self.redColor = [UIColor colorWithRed:227/255.0 green:11/255.0 blue:32/255.0 alpha:1.0];
    self.grayColor = [UIColor colorWithRed:114/255.0 green:114/255.0 blue:114/255.0 alpha:1.0];
    
    self.showInterstitialButton.layer.cornerRadius = 25;
    [self.showInterstitialButton setTitleColor:[UIColor whiteColor] forState:normal];
    [self.showInterstitialButton setBackgroundColor:self.grayColor];
    [self.showInterstitialButton setAlpha:0.5];
    
    [self.waitingLabel setAlpha:0.5];
    [self.loadingLabel setAlpha:1];
    [self.loadedLabel setAlpha:0.5];
    // ここまで
    
    [self loadInterstitial];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/** インタースティシャル広告を表示するボタンのターゲットメソッド */
- (IBAction)showInterstitialButtonDidTouchUpInside:(id)sender {
    [self.showInterstitialButton setBackgroundColor:self.grayColor];
    [self.showInterstitialButton setAlpha:0.5];
    self.showInterstitialButton.enabled = NO;
    
    if (self.interstitial) {
      [self.interstitial presentFromRootViewController:self];
    } else {
      NSLog(@"Ad wasn't ready");
    }
}

- (void)loadInterstitial {
    // 実際に使用するAd Unit Idは営業担当者から別途お知らせ致します。
    [super viewDidLoad];
    GADRequest *request = [GADRequest request];
    [GADInterstitialAd loadWithAdUnitID:ADMOB_INTERSTITIAL_ID
                                request:request
                      completionHandler:^(GADInterstitialAd *ad, NSError *error) {
        if (error) {
            NSLog(@"Failed to load interstitial ad with error: %@", [error localizedDescription]);
            return;
        }
        self.interstitial = ad;
        self.interstitial.fullScreenContentDelegate = self;
        
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:0.5];
        [self.loadedLabel setAlpha:1];
        
        [self.showInterstitialButton setBackgroundColor:self.redColor];
        [self.showInterstitialButton setAlpha:1];
        self.showInterstitialButton.enabled = YES;
    }];
}

#pragma mark -
#pragma mark GADFullScreenContentDelegate

- (void)adDidPresentFullScreenContent:(id)ad {
    NSLog(@"Ad did present full screen content.");
}

- (void)ad:(id)ad didFailToPresentFullScreenContentWithError:(NSError *)error {
    NSLog(@"Ad failed to present full screen content with error %@.", [error localizedDescription]);
}

- (void)adDidDismissFullScreenContent:(id)ad {
    NSLog(@"Ad did dismiss full screen content.");
    [self.waitingLabel setAlpha:1];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:0.5];
    
    // 15秒待ってから再読み込みします
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:1];
        [self.loadedLabel setAlpha:0.5];
        
        [self loadInterstitial];
    });
}

@end
