//
//  AdMobNativeAdViewController.m
//  AdstirSampleApp
//

#import "AdMobNativeAdViewController.h"
#import "AdMobNativeAdView.h"
@import GoogleMobileAds;

NSString *const kCustomEventNativeAdUnitID = @"ca-app-pub-5957222543250452/2944253571";

@interface AdMobNativeAdViewController () <GADNativeAdLoaderDelegate, GADNativeAdDelegate>

@property(nonatomic, weak) IBOutlet UIView *nativeAdPlaceholder;

@property(nonatomic, strong) GADAdLoader *adLoader;

@end

@implementation AdMobNativeAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    GADNativeAdViewAdOptions *adViewOptions = [[GADNativeAdViewAdOptions alloc] init];
    
    self.adLoader = [[GADAdLoader alloc] initWithAdUnitID:kCustomEventNativeAdUnitID
                                       rootViewController:self
                                                  adTypes:@[ GADAdLoaderAdTypeNative ]
                                                  options:@[ adViewOptions ]];
    self.adLoader.delegate = self;
    [self.adLoader loadRequest:[GADRequest request]];
}

- (void)replaceNativeAdView:(UIView *)nativeAdView inPlaceholder:(UIView *)placeholder {
    // Remove anything currently in the placeholder.
    NSArray *currentSubviews = [placeholder.subviews copy];
    for (UIView *subview in currentSubviews) {
        [subview removeFromSuperview];
    }
    
    if (!nativeAdView) {
        return;
    }
    
    // Add new ad view and set constraints to fill its container.
    [placeholder addSubview:nativeAdView];
    nativeAdView.translatesAutoresizingMaskIntoConstraints = NO;
    
    NSDictionary *viewDictionary = NSDictionaryOfVariableBindings(nativeAdView);
    [self.view addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[nativeAdView]|"
                                                                      options:0
                                                                      metrics:nil
                                                                        views:viewDictionary]];
    [self.view addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[nativeAdView]|"
                                                                      options:0
                                                                      metrics:nil
                                                                        views:viewDictionary]];
}

#pragma mark GADNativeAdLoaderDelegate implementation

- (void)adLoader:(GADAdLoader *)adLoader didReceiveNativeAd:(GADNativeAd *)nativeAd {
    NSLog(@"%s, %@", __PRETTY_FUNCTION__, nativeAd);
    
    AdMobNativeAdView *nativeAdView =
    [[NSBundle mainBundle] loadNibNamed:@"AdMobNativeAdView" owner:nil options:nil]
    .firstObject;
    nativeAdView.nativeAd = nativeAd;
    UIView *placeholder = self.nativeAdPlaceholder;
    [self replaceNativeAdView:nativeAdView inPlaceholder:placeholder];
    
    // バナー画像や動画などのコンテンツを配置します
    [nativeAdView.mediaView setMediaContent:nativeAd.mediaContent];
    // タイトルを設定します
    ((UILabel *)nativeAdView.headlineView).text = nativeAd.headline;
    // 説明文を設定します
    ((UILabel *)nativeAdView.bodyView).text = nativeAd.body;
    // CATテキストを設定します
    [((UIButton *)nativeAdView.callToActionView) setTitle:nativeAd.callToAction
                                                 forState:UIControlStateNormal];
    // アイコン画像を設定します
    ((UIImageView *)nativeAdView.iconView).image = nativeAd.icon.image;
    // 広告主を設定します
    ((UILabel *)nativeAdView.advertiserView).text = nativeAd.advertiser;
    // レーティングを設定します
    ((UILabel *)nativeAdView.starRatingView).text = nativeAd.starRating.stringValue;
}

#pragma mark GADNativeAdDelegate implementation

- (void)adLoader:(GADAdLoader *)adLoader didFailToReceiveAdWithError:(NSError *)error {
    NSLog(@"%@ failed with error: %@", adLoader, error.localizedDescription);
}

@end
