#import "BannerAdViewController.h"
@import AdstirAds;

@interface BannerAdViewController () <AdstirMraidViewDelegate>

@property (strong, nonatomic) AdstirMraidView *adstir;

@end

@implementation BannerAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // 広告表示位置: センタリング、広告サイズ: 320,50 の場合
    CGFloat originX = (self.view.frame.size.width - kAdstirAdSize320x50.size.width) / 2;
    CGFloat originY = (self.view.frame.size.height - kAdstirAdSize320x50.size.height) /2;
    AdstirMraidView *aAdstir = [[AdstirMraidView alloc] initWithAdSize:kAdstirAdSize320x50 origin:CGPointMake(originX, originY)
                                                                 media:@"MEDIA-b8608ec6" spot:3];
    
    aAdstir.intervalTime = 60;
    [self.view addSubview:aAdstir];
    aAdstir.delegate = self;
    self.adstir = aAdstir;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    // 広告の読み込みを再開します。
    [self.adstir start];
}

- (void)viewWillDisappear:(BOOL)animated
{
    // 広告の読み込みを停止します。
    [self.adstir stop];
    // この他にも、Viewが非表示になると思われる箇所では、stopを呼び出すことで無駄なインプレッションが発生しません。
}

#pragma mark -
#pragma mark AdstirMraidViewDelegate

/**
 Perfoemed before expanded screen will present.
 
 エキスパンド広告が表示される前に呼び出されます。
 */
- (void)adstirMraidViewWillPresentScreen:(AdstirMraidView * __asadnonnull)mraidView
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
}

/**
 Perfoemed after expanded screen did present.
 
 エキスパンド広告が表示された後に呼び出されます。
 */
- (void)adstirMraidViewDidPresentScreen:(AdstirMraidView * __asadnonnull)mraidView
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
}

/**
 Performed before expanded screen will dismiss.
 
 エキスパンド広告が閉じられる前に呼び出されます。
 */
- (void)adstirMraidViewWillDismissScreen:(AdstirMraidView * __asadnonnull)mraidView
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
}

/**
 Performed before leave application.
 
 広告がクリックされ、標準ブラウザなどを開く前に呼び出されます。
 */
- (void)adstirMraidViewWillLeaveApplication:(AdstirMraidView * __asadnonnull)mraidView
{
    NSLog(@"%s", __PRETTY_FUNCTION__);
}

@end
