#import "IncentivizedVideoAdViewController.h"
@import AdstirAds;


@interface IncentivizedVideoAdViewController () <AdstirVideoRewardDelegate>

@property (weak, nonatomic) IBOutlet UILabel *statusLabel;

@property (weak, nonatomic) IBOutlet UIButton *showVideoButton;

@property (nonatomic, strong) AdstirVideoReward *videoReward;
@property (weak, nonatomic) IBOutlet UILabel *waitingLabel;
@property (weak, nonatomic) IBOutlet UILabel *loadingLabel;
@property (weak, nonatomic) IBOutlet UILabel *loadedLabel;
@property (weak, nonatomic) IBOutlet UILabel *rewardCountLabel;
@property (nonatomic, strong)UIColor *redColor;
@property (nonatomic, strong)UIColor *grayColor;

@end


@implementation IncentivizedVideoAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // UI設定 ここから
    self.redColor = [UIColor colorWithRed:227/255.0 green:11/255.0 blue:32/255.0 alpha:1.0];
    self.grayColor = [UIColor colorWithRed:114/255.0 green:114/255.0 blue:114/255.0 alpha:1.0];
    
    self.showVideoButton.layer.cornerRadius = 25;
    [self.showVideoButton setTitleColor:[UIColor whiteColor] forState:normal];
    [self.showVideoButton setBackgroundColor:self.grayColor];
    [self.showVideoButton setAlpha:0.5];
    
    [self.waitingLabel setAlpha:0.5];
    [self.loadingLabel setAlpha:1];
    [self.loadedLabel setAlpha:0.5];
    
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    NSDictionary *dictionary = [NSDictionary dictionaryWithObjectsAndKeys:[NSNumber numberWithInteger:0], @"points", nil];
    [userDefaults registerDefaults:dictionary];
    
    NSNumber *rewardCount = [userDefaults objectForKey:@"points"];
    self.rewardCountLabel.text = [rewardCount stringValue];
    // ここまで
    
    
    AdstirVideoReward *aVideoReward = [[AdstirVideoReward alloc] initWithMedia:@"MEDIA-b8608ec6" spot:1];
    aVideoReward.delegate = self;
    
    self.videoReward = aVideoReward;
    [self.videoReward load];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/** リワード広告を表示するボタンのターゲットメソッド */
- (IBAction)showVideoButtonDidTouchUpInside:(id)sender
{
    [self.showVideoButton setBackgroundColor:self.grayColor];
    [self.showVideoButton setAlpha:0.5];
    self.showVideoButton.enabled = NO;
    
    
    if ([self.videoReward canShow]) {
        [self.videoReward showFromViewController:self.parentViewController];
    }
}



- (void)dealloc
{
    // デリゲートを解放します。解放を忘れるとクラッシュする可能性があります。
    self.videoReward.delegate = nil;
    // 広告の制御インスタンスを解放します。
    self.videoReward = nil;
}

#pragma mark -
#pragma mark AdstirVideoRewardDelegate

/** 動画の読み込み完了イベントを受け取ります */
- (void)adstirVideoRewardDidLoad:(AdstirVideoReward *)videoReward
{
    [self.waitingLabel setAlpha:0.5];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:1];
    
    [self.showVideoButton setBackgroundColor:self.redColor];
    [self.showVideoButton setAlpha:1];
    self.showVideoButton.enabled = YES;
}

/**
 動画の再生準備に失敗した際に呼び出されます
 */
- (void)adstirVideoReward:(AdstirVideoReward *)videoReward didFailToLoadWithError:(NSError *)error
{
    [self.waitingLabel setAlpha:1];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:0.5];
    
    // 15秒待ってから再読み込みします
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:1];
        [self.loadedLabel setAlpha:0.5];
        
        [self.videoReward load];
    });
}

/** 動画の再生開始イベントを受け取ります */
- (void)adstirVideoRewardDidStart:(AdstirVideoReward *)videoReward
{
}

/** 動画のインセンティブ付与の完了イベントを受け取ります */
- (void)adstirVideoRewardDidComplete:(AdstirVideoReward *)videoReward
{
    NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
    NSNumber *rewardCount = [userDefaults objectForKey:@"points"];
    rewardCount = [NSNumber numberWithInt:[rewardCount intValue] + 1];
    [userDefaults setObject:rewardCount forKey:@"points"];
    self.rewardCountLabel.text = [rewardCount stringValue];
}

/** 動画再生のキャンセルイベントを受け取ります */
- (void)adstirVideoReward:(AdstirVideoReward *)videoReward didFailToPlaybackWithError:(NSError *)error
{
    [self.waitingLabel setAlpha:1];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:0.5];
    
    // 15秒待ってから再読み込みします
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:1];
        [self.loadedLabel setAlpha:0.5];
        
        [self.videoReward load];
    });
}

/** 動画再生ビューが閉じられたことを受け取ります */
- (void)adstirVideoRewardDidClose:(AdstirVideoReward *)videoReward
{
    [self.waitingLabel setAlpha:1];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:0.5];
    
    // 15秒待ってから再読み込みします
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:1];
        [self.loadedLabel setAlpha:0.5];
        
        [self.videoReward load];
    });
}

@end
