#import "InterstitialAdViewController.h"
@import AdstirAds;

@interface InterstitialAdViewController () <AdstirInterstitialDelegate>
@property (weak, nonatomic) IBOutlet UIButton *showInterstitialButton;
@property (weak, nonatomic) IBOutlet UILabel *waitingLabel;
@property (weak, nonatomic) IBOutlet UILabel *loadingLabel;
@property (weak, nonatomic) IBOutlet UILabel *loadedLabel;
@property (strong, nonatomic) AdstirInterstitial *interstitial;
@property (nonatomic, strong)UIColor *redColor;
@property (nonatomic, strong)UIColor *grayColor;
@end

@implementation InterstitialAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // UI設定 ここから
    self.redColor = [UIColor colorWithRed:227/255.0 green:11/255.0 blue:32/255.0 alpha:1.0];
    self.grayColor = [UIColor colorWithRed:114/255.0 green:114/255.0 blue:114/255.0 alpha:1.0];
    
    self.showInterstitialButton.layer.cornerRadius = 25;
    [self.showInterstitialButton setTitleColor:[UIColor whiteColor] forState:normal];
    [self.showInterstitialButton setBackgroundColor:self.grayColor];
    [self.showInterstitialButton setAlpha:0.5];
    
    [self.waitingLabel setAlpha:0.5];
    [self.loadingLabel setAlpha:1];
    [self.loadedLabel setAlpha:0.5];
    // ここまで
    
    AdstirInterstitial *interstitial = [[AdstirInterstitial alloc] initWithMedia:@"MEDIA-b8608ec6" spot:2];
    interstitial.delegate = self;
    self.interstitial = interstitial;
    
    [interstitial load];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/** インタースティシャル広告を表示するボタンのターゲットメソッド */
- (IBAction)showInterstitialButtonDidTouchUpInside:(id)sender {
    [self.showInterstitialButton setBackgroundColor:self.grayColor];
    [self.showInterstitialButton setAlpha:0.5];
    self.showInterstitialButton.enabled = NO;
    
    
    if (self.interstitial.canShow) {
        [self.interstitial showFromViewController:self.parentViewController];
    }
}


#pragma mark -
#pragma mark AdstirInterstitialDelegate

- (void)dealloc
{
    // デリゲートを解放します。解放を忘れるとクラッシュする可能性があります。
    self.interstitial.delegate = nil;
    // 広告の制御インスタンスを解放します。
    self.interstitial = nil;
}

/**
 Called when get ready to show ad
 
 インタースティシャル広告の準備が完了した際に呼び出されます
 */
- (void)adstirInterstitialDidLoad:(AdstirInterstitial * __asadnonnull)interstitial
{
    [self.waitingLabel setAlpha:0.5];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:1];
    
    [self.showInterstitialButton setBackgroundColor:self.redColor];
    [self.showInterstitialButton setAlpha:1];
    self.showInterstitialButton.enabled = YES;
}

/**
 Called when failed to load ad
 
 インタースティシャル広告の準備に失敗した際に呼び出されます
 */
- (void)adstirInterstitial:(AdstirInterstitial * __asadnonnull)interstitial didFailToLoadWithError:(NSError * __asadnonnull)error
{
    [self.waitingLabel setAlpha:1];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:0.5];
    
    // 15秒待ってから再読み込みします
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:1];
        [self.loadedLabel setAlpha:0.5];
        
        [self.interstitial load];
    });
}

/**
 Called when interstitial ad is shown
 
 インタースティシャル広告が表示された際に呼び出されます
 */
- (void)adstirInterstitialDidShow:(AdstirInterstitial * __asadnonnull)interstitial
{
}

/**
 Called when failed to show ad
 
 インタースティシャル広告の表示に失敗した際に呼び出されます
 */
- (void)adstirInterstitial:(AdstirInterstitial * __asadnonnull)interstitial didFailToShowWithError:(NSError * __asadnonnull)error
{
    [self.waitingLabel setAlpha:1];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:0.5];
    
    // 15秒待ってから再読み込みします
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:1];
        [self.loadedLabel setAlpha:0.5];
        
        [self.interstitial load];
    });
}

/**
 Called when ad was closed
 
 インタースティシャル広告が閉じられたときに呼び出されます
 */
- (void)adstirInterstitialDidClose:(AdstirInterstitial * __asadnonnull)interstitial
{
    [self.waitingLabel setAlpha:1];
    [self.loadingLabel setAlpha:0.5];
    [self.loadedLabel setAlpha:0.5];
    
    // 15秒待ってから再読み込みします
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(15.0f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.waitingLabel setAlpha:0.5];
        [self.loadingLabel setAlpha:1];
        [self.loadedLabel setAlpha:0.5];
        
        [self.interstitial load];
    });
}

@end
