#import "NativeAdViewController.h"
@import AdstirAds;

@interface NativeAdViewController () <AdstirNativeAdDelegate>
@property (weak, nonatomic) IBOutlet UILabel *titleLabel;
@property (weak, nonatomic) IBOutlet UILabel *textLabel;
@property (weak, nonatomic) IBOutlet UILabel *sponsoredLabel;
@property (weak, nonatomic) IBOutlet UIImageView *imageView;
@property (weak, nonatomic) IBOutlet UIButton *ctaButton;
@property (weak, nonatomic) IBOutlet UIButton *optoutButton;

@property (strong, nonatomic) AdstirNativeAd* nativead;
@property (strong, nonatomic) AdstirNativeAdResponse* nativeadResponse;
@end

@implementation NativeAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // インスタンス生成
    self.nativead = [[AdstirNativeAd alloc] init];
    self.nativead.media = @"MEDIA-b8608ec6";
    self.nativead.spot = 4;
    
    self.imageView.contentMode = UIViewContentModeScaleAspectFit;
    
    // ガイドラインで規定されているスポンサー表記を実装した通りに設定してください
    self.nativead.sponsoredText = @"SPONSORED";
    // 広告に必要な要素を要求するパラメーターは、設定する必要がなくなりました。広告枠登録時に設定した内容で配信されます
    // 広告レスポンスを受け取るDelegateを設定します
    self.nativead.delegate = self;
    [self.nativead getAd];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)adstirNativeAdDidReceiveAd:(AdstirNativeAd*)ad response:(AdstirNativeAdResponse*)response{
    // 広告レスポンスが正常に取得できた時に行う処理を実装します
    // AdstirNativeAdDelegateのメソッドはすべてバックグラウンドスレッドで動作します
    self.nativeadResponse = response;
    dispatch_sync(dispatch_get_main_queue(), ^(void){
        self.titleLabel.text = response.title;
        self.textLabel.text = response.descriptionText;
        self.sponsoredLabel.text = ad.sponsoredText;
        [self.ctaButton setTitle:response.cta forState:UIControlStateNormal];
        [response bindImageToImageView:self.imageView];
        
        // UIの非表示設定を解除します
        self.titleLabel.hidden = NO;
        self.textLabel.hidden = NO;
        self.sponsoredLabel.hidden = NO;
        self.ctaButton.hidden = NO;
        self.imageView.hidden = NO;
        
        // オプトアウトボタンの設定
        [response bindOptoutImageToButton:self.optoutButton];
    });
    // 広告を表示するときにimpressionを呼び出します
    [response impression];
}

- (void)adstirNativeAdDidFailToReceiveAd:(AdstirNativeAd*)ad{
    // 広告レスポンスが正常に取得できなかった時に行う処理を実装します
    // AdstirNativeAdDelegateのメソッドはすべてバックグラウンドスレッドで動作します
    NSLog(@"%s", __PRETTY_FUNCTION__);
}

- (IBAction)adClick:(id)sender {
    // 広告がクリックされたときはclickを呼び出します
    [self.nativeadResponse click];
}

- (IBAction)optoutClick:(id)sender {
    // オプトアウトボタンがクリックされた時はclickOptoutを呼び出します
    [self.nativeadResponse clickOptout];
}



- (void)dealloc {
    // デリゲートを解放します。
    self.nativead.delegate = nil;
    self.nativead = nil;
    self.nativeadResponse = nil;
}

@end
