#import "SceneDelegate.h"
#import "MainViewController.h"
@import AdstirAds;

@interface SceneDelegate () <AdstirAppOpenAdDelegate>
@property (strong, nonatomic) AdstirAppOpenAd * adstirAppOpenAd;

@end

@implementation SceneDelegate


- (void)scene:(UIScene *)scene willConnectToSession:(UISceneSession *)session options:(UISceneConnectionOptions *)connectionOptions {
    // Use this method to optionally configure and attach the UIWindow `window` to the provided UIWindowScene `scene`.
    // If using a storyboard, the `window` property will automatically be initialized and attached to the scene.
    // This delegate does not imply the connecting scene or session are new (see `application:configurationForConnectingSceneSession` instead).
}


- (void)sceneDidDisconnect:(UIScene *)scene {
    // Called as the scene is being released by the system.
    // This occurs shortly after the scene enters the background, or when its session is discarded.
    // Release any resources associated with this scene that can be re-created the next time the scene connects.
    // The scene may re-connect later, as its session was not necessarily discarded (see `application:didDiscardSceneSessions` instead).
}


- (void)sceneDidBecomeActive:(UIScene *)scene {
    // Called when the scene has moved from an inactive state to an active state.
    // Use this method to restart any tasks that were paused (or not yet started) when the scene was inactive.
    
    // アプリ復帰時に広告の表示を試みます
    // ここでは広告表示のないMainViewControllerを表示している時だけ広告の表示を試みます
    // こちらの実装例ではアプリの起動時には広告が表示されません。
    UINavigationController *nav = (UINavigationController*)_window.rootViewController;
    if ([nav.topViewController isKindOfClass:[MainViewController class]]) {
        [self showIfAvailable];
    }
}


- (void)sceneWillResignActive:(UIScene *)scene {
    // Called when the scene will move from an active state to an inactive state.
    // This may occur due to temporary interruptions (ex. an incoming phone call).
}


- (void)sceneWillEnterForeground:(UIScene *)scene {
    // Called as the scene transitions from the background to the foreground.
    // Use this method to undo the changes made on entering the background.
}


- (void)sceneDidEnterBackground:(UIScene *)scene {
    // Called as the scene transitions from the foreground to the background.
    // Use this method to save data, release shared resources, and store enough scene-specific state information
    // to restore the scene back to its current state.
}

- (void)showIfAvailable {
    // アプリ起動時広告の初期化を行います
    if (self.adstirAppOpenAd == nil) {
        self.adstirAppOpenAd = [[AdstirAppOpenAd alloc] initWithMedia:@"MEDIA-b8608ec6" spot:7];
        // 必要に応じてdelegateの設定を行います
        self.adstirAppOpenAd.delegate = self;
    }

    // アプリ起動時広告の読み込みが完了している場合は表示、そうでない場合は読み込みを行います
    if ([self.adstirAppOpenAd canShow]) {
        [self.adstirAppOpenAd show];
    } else {
        [self.adstirAppOpenAd load];
    }
}

/** アプリ起動時広告の準備が完了した際に呼び出されます */
- (void)adstirAppOpenAdDidLoad:(AdstirAppOpenAd *)appOpenAd
{
}

/** アプリ起動時広告の準備に失敗した際に呼び出されます */
- (void)adstirAppOpenAd:(AdstirAppOpenAd *)appOpenAd didFailToLoadWithError:(NSError *)error
{
}

/** アプリ起動時広告が表示された際に呼び出されます */
- (void)adstirAppOpenAdDidShow:(AdstirAppOpenAd *)appOpenAd
{
}

/** アプリ起動時広告の表示に失敗した際に呼び出されます */
- (void)adstirAppOpenAd:(AdstirAppOpenAd *)appOpenAd didFailToShowWithError:(NSError *)error
{
}

/** アプリ起動時広告が閉じられたときに呼び出されます */
- (void)adstirAppOpenAdDidClose:(AdstirAppOpenAd *)appOpenAd
{
}


@end
